<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Help-Index-Schema"
                              xmlns:wwhindex="urn:WebWorks-Help-Index-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwindex="urn:WebWorks-Index-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwindex wwlinks wwmode wwfiles wwdoc wwsplits wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterIndexSplitFileType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="wwhindex" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwsplits-files-by-groupid-type" match="wwsplits:File" use="concat(@groupID, ':', @type)" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Iterate input documents -->
   <!--                         -->
   <xsl:for-each select="$GlobalFiles[1]">
    <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-type', $ParameterDependsType)" />

    <xsl:value-of select="wwprogress:Start(count($VarFilesByType))" />

    <xsl:for-each select="$VarFilesByType">
     <xsl:value-of select="wwprogress:Start(1)" />

     <xsl:variable name="VarFilesDocument" select="." />

     <!-- Load splits -->
     <!--             -->
     <xsl:variable name="VarFilesSplits" select="key('wwfiles-files-by-groupid-type', concat($VarFilesDocument/@groupID, ':', $ParameterSplitsType))[1]" />
     <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesSplits/@path)" />

     <xsl:for-each select="$VarSplits[1]">
      <!-- Split -->
      <!--       -->
      <xsl:variable name="VarSplit" select="key('wwsplits-files-by-groupid-type', concat($VarFilesDocument/@groupID, ':', $ParameterIndexSplitFileType))[1]" />

      <!-- Transform -->
      <!--           -->
      <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarSplit/@path, '', $VarFilesDocument/@groupID, $VarFilesDocument/@documentID, $GlobalActionChecksum)" />
      <xsl:if test="not($VarUpToDate)">
       <xsl:variable name="VarResultAsXML">
        <!-- Load document -->
        <!--               -->
        <xsl:variable name="VarIndex" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesDocument/@path)" />

        <xsl:call-template name="Index">
         <xsl:with-param name="ParamSplit" select="$VarSplit" />
         <xsl:with-param name="ParamIndex" select="$VarIndex" />
        </xsl:call-template>
       </xsl:variable>
       <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
       <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarSplit/@path, wwprojext:GetFormatSetting('encoding', 'utf-8'), 'xml', '1.0', 'yes')" />
      </xsl:if>

      <!-- Report Files -->
      <!--              -->
      <wwfiles:File path="{$VarSplit/@path}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarSplit/@path)}" projectchecksum="" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
       <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
       <wwfiles:Depends path="{$VarFilesSplits/@path}" checksum="{$VarFilesSplits/@checksum}" groupID="{$VarFilesSplits/@groupID}" documentID="{$VarFilesSplits/@documentID}" />
       <wwfiles:Depends path="{$VarFilesDocument/@path}" checksum="{$VarFilesDocument/@checksum}" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" />
      </wwfiles:File>
     </xsl:for-each>

     <xsl:value-of select="wwprogress:End()" />
    </xsl:for-each>

    <xsl:value-of select="wwprogress:End()" />
   </xsl:for-each>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="Index">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamIndex" />

  <wwhindex:WebWorksHelpIX version="5.0">
   <!-- Generate Index? -->
   <!--                 -->
   <xsl:if test="wwprojext:GetFormatSetting('index-generate', 'true') = 'true'">
    <xsl:call-template name="Sections">
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     <xsl:with-param name="ParamIndex" select="$ParamIndex/wwindex:Index" />
    </xsl:call-template>
   </xsl:if>
  </wwhindex:WebWorksHelpIX>
 </xsl:template>


 <xsl:template name="Sections">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamIndex" />

  <xsl:for-each select="$ParamIndex/wwindex:Section">
   <xsl:variable name="VarSection" select="." />

   <xsl:call-template name="Groups">
    <xsl:with-param name="ParamSplit" select="$ParamSplit" />
    <xsl:with-param name="ParamSection" select="$VarSection" />
   </xsl:call-template>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Groups">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamSection" />

  <xsl:for-each select="$ParamSection/wwindex:Group">
   <xsl:variable name="VarGroup" select="." />

   <wwhindex:g t="{$VarGroup/@name}" o="{format-number($ParamSection/@position, '000')}">
    <xsl:if test="$VarGroup/@name != $VarGroup/@sort">
     <xsl:attribute name="s">
      <xsl:value-of select="$VarGroup/@sort" />
     </xsl:attribute>
    </xsl:if>

    <xsl:call-template name="Entries">
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     <xsl:with-param name="ParamParent" select="$VarGroup" />
    </xsl:call-template>
   </wwhindex:g>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Entries">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamParent" />

  <xsl:for-each select="$ParamParent/wwindex:Entry">
   <xsl:variable name="VarEntry" select="." />

   <xsl:variable name="VarSee" select="$VarEntry/wwindex:See[1]" />

   <!-- Emit entry -->
   <!--            -->
   <wwhindex:i t="{$VarEntry/@name}">
    <xsl:if test="$VarEntry/@name != $VarEntry/@sort">
     <xsl:attribute name="s">
      <xsl:value-of select="$VarEntry/@sort" />
     </xsl:attribute>
    </xsl:if>
    <xsl:if test="count($VarSee) = 1">
     <xsl:attribute name="c">
      <xsl:value-of select="$VarSee/@entry" />
     </xsl:attribute>
     <xsl:attribute name="cgt">
      <xsl:value-of select="$VarSee/@group" />
     </xsl:attribute>
     <xsl:if test="$VarSee/@groupsort != $VarSee/@group">
      <xsl:attribute name="cgs">
       <xsl:value-of select="$VarSee/@groupsort" />
      </xsl:attribute>
     </xsl:if>
     <xsl:attribute name="cgo">
      <xsl:value-of select="format-number($VarSee/@sectionposition, '000')" />
     </xsl:attribute>
    </xsl:if>

    <xsl:if test="count($VarSee) = 0">
     <!-- Links -->
     <!--       -->
     <xsl:for-each select="$VarEntry/wwindex:Link">
      <xsl:variable name="VarLink" select="." />

      <xsl:choose>
       <xsl:when test="$VarLink/@first = 'true'">
        <wwhindex:j l="{$VarLink/@fileposition - 1}" />
       </xsl:when>

       <xsl:otherwise>
        <wwhindex:j>
         <xsl:attribute name="l">
          <xsl:value-of select="$VarLink/@fileposition - 1" />
          <xsl:text>#</xsl:text>
          <xsl:value-of select="$VarLink/@anchor" />
         </xsl:attribute>
        </wwhindex:j>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:for-each>
    </xsl:if>

    <!-- Process children -->
    <!--                  -->
    <xsl:call-template name="Entries">
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     <xsl:with-param name="ParamParent" select="$VarEntry" />
    </xsl:call-template>
   </wwhindex:i>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
